<?php

namespace App\Models\Customer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Filiale extends Model 
{

    protected $table = 'customer_filiale';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function service()
    {
        return $this->hasMany('App\Models\Customer\Service');
    }

    public function groupe()
    {
        return $this->belongsTo('App\Models\Customer\Groupe');
    }

}